"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userRouter = void 0;
const userController_1 = require("../controllers/userController");
const auth_1 = require("../middleware/auth");
// import { upload } from "../middleware/multerMW";
const express = require("express");
const multer = require("multer");
const fs = require("fs");
const path = require("path");
const router = express.Router();
// Configure multer storage
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        const folder = "/uploads/order";
        const dir = path.join(__dirname, `../${folder}`);
        fs.mkdir(dir, { recursive: true }, (err) => {
            if (err) {
                console.error("Error creating upload directory:", err);
                return cb(new Error(`Failed to create upload directory: ${err.message}`), "");
            }
            cb(null, dir);
        });
    },
    filename: (req, file, cb) => {
        const uniqueName = `${Date.now()}_${file.originalname}`;
        cb(null, uniqueName);
    },
});
const upload = multer({ storage });
// const router = Router();
// ✅ Define routes BEFORE exporting
router.post("/username", userController_1.usersController.updateName);
router.get("/info", auth_1.authenticate, userController_1.usersController.profile);
router.get("/balance", auth_1.authenticate, userController_1.usersController.balance);
router.post("/deposit/balance", auth_1.authenticate, upload.fields([{ name: "receipt", maxCount: 1 }]), userController_1.usersController.deposit);
router.get("/deposit/orders", auth_1.authenticate, userController_1.usersController.depositOrders);
router.get("/referral/info", auth_1.authenticate, userController_1.usersController.referrals);
router.post("/withdraw/balance", auth_1.authenticate, userController_1.usersController.withdraw);
router.get("/withdraw/orders", auth_1.authenticate, userController_1.usersController.withdrawOrders);
router.get("/vip/update", userController_1.usersController.vip);
router.post("/task/make", auth_1.authenticate, userController_1.usersController.makeTask);
router.get("/task/info", auth_1.authenticate, userController_1.usersController.taskInfo);
exports.userRouter = router;
// src/routes/userRoute.ts
// const router = Router();
// export const usersRouter = router;
// usersRouter.post("/patientDistribution", usersController.register);
