"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// src/routes/index.ts
const express_1 = require("express");
const adminRoute_1 = require("./adminRoute");
const settingRoute_1 = require("./settingRoute");
const authRoute_1 = require("./authRoute");
const userRoute_1 = require("./userRoute");
const router = (0, express_1.Router)();
// Health checks
// router.use("/admin", healthRoutes);
router.use("/auth", authRoute_1.authRouter);
router.use("/admin", adminRoute_1.adminRouter);
router.use("/system", settingRoute_1.systemRouter);
router.use("/user", userRoute_1.userRouter);
// router.use("/vip", healthRoutes);
// router.use("/auth", healthRoutes);
// Sync management
// Default route
router.get("/", (req, res) => {
    res.json({
        message: "COO Dashboard Sync Manager API",
        version: "1.0.0",
        endpoints: {
            health: "/health",
            sync: "/sync",
        },
    });
});
exports.default = router;
